/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.servlet.NavigationAction;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.TableData;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeSelectionListener;
import com.ibm.psw.wcl.components.table.DefaultExtendedTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TasksTableModel
extends DefaultExtendedTableModel
implements NavigationTreeSelectionListener {
    private static final List COLUMN_KEYS = new ArrayList(2);
    private String workareaName;
    private UserObject userObj;

    public TasksTableModel(String workareaName, UserObject userObj) {
        this.workareaName = workareaName;
        this.userObj = userObj;
        userObj.addTreeSelectionListener(this);
        this.setData(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(userObj.getTreeSelection()));
    }

    public UserObject getUserObject() {
        return this.userObj;
    }

    public void treeSelectionChanged(String oldSelection, String newSelection) {
        BonsaiTreeNode node = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(newSelection);
        if (node.getWorkarea().equals(this.workareaName)) {
            this.setData(node);
        }
    }

    public synchronized void setData(BonsaiTreeNode node) {
        List data = BonsaiTreeManager.getBonsaiTreeManager().getTableProperties(node.getId(), this.userObj);
        NameTableCellBean cell = null;
        Iterator i = data.iterator();
        while (i.hasNext()) {
            cell = (NameTableCellBean)((Map)i.next()).get("Name");
            if (cell == null) continue;
            cell.setUrl(NavigationAction.getSelectionUrl(cell.getId()));
            cell.setUrlTarget("navigation_frame");
        }
        i = TaskManager.getTaskManager().getTasks(node, this.userObj).iterator();
        while (i.hasNext()) {
            data.add(((TaskNode)i.next()).getTableProperties(this.userObj));
        }
        TableData tableData = new TableData(COLUMN_KEYS, data, true, null);
        this.setDataVector(tableData.getData(), tableData.getColumnNames(this.userObj.getLocale()));
    }

    static {
        COLUMN_KEYS.add("Name");
        COLUMN_KEYS.add("Caption");
    }
}

